/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.remsrv;

import com.ibm.hwmca.base.remsrv.RemoteServiceErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.upgrddat.MigrateOS2Data;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.NativeString;
import com.ibm.hwmca.fw.util.Trace;

public class RemoteServiceData
implements RemoteServiceErrorIds,
MigrateOS2Data {
    private static final String TRACE_MASKT = "HREMDATT";
    private static final String TRACE_MASKF = "HREMDATF";
    private static final String TRACE_MASKD = "HREMDATD";
    private static final String PERSIST_KEY = "com.ibm.hwmca.base.remsrv.RemoteServiceData";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-110, "RemServData");
    private static RemoteServiceData instance = null;
    private RemoteServicePersistentData data = null;

    private RemoteServiceData() {
        Trace.trace(TRACE_MASKT, "-> RemoteServiceData()");
        this.data = new RemoteServicePersistentData();
        this.data.enabled = false;
        this.data.autoServiceCall = false;
        this.data.serviceNumber = "1-800-IBM-SERV";
        Trace.trace(TRACE_MASKT, "<- RemoteServiceData()");
    }

    private RemoteServiceData(RemoteServicePersistentData data) {
        Trace.trace(TRACE_MASKT, "<> RemoteServiceData(" + data + ")");
        this.data = data;
    }

    private void persistData() {
        Trace.trace(TRACE_MASKT, "-> persistData()");
        try {
            PersistenceManager pm = PersistenceManager.getPersistenceManager();
            pm.write(PERSIST_KEY, this.data);
        }
        catch (PersistenceException e) {
            new FrameworkLog(logInfo, 7, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- persistData()");
    }

    public static RemoteServiceData getRemoteServiceData() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        Trace.trace(TRACE_MASKT, "-> setEnabled(" + enabled + ")");
        RemoteServicePersistentData remoteServicePersistentData = this.data;
        synchronized (remoteServicePersistentData) {
            this.data.enabled = enabled;
            this.persistData();
        }
        Trace.trace(TRACE_MASKT, "<- setEnabled()");
    }

    public boolean isEnabled() {
        Trace.trace(TRACE_MASKT, "<> isEnabled()");
        return this.data.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoServiceCall(boolean enabled) {
        Trace.trace(TRACE_MASKT, "-> setAutoServiceCall(" + enabled + ")");
        RemoteServicePersistentData remoteServicePersistentData = this.data;
        synchronized (remoteServicePersistentData) {
            this.data.autoServiceCall = enabled;
            this.persistData();
        }
        Trace.trace(TRACE_MASKT, "<- setAutoServiceCall()");
    }

    public boolean isAutoServiceCall() {
        Trace.trace(TRACE_MASKT, "<> isAutoServiceCall()");
        return this.data.autoServiceCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceNumber(String number) {
        Trace.trace(TRACE_MASKT, "-> setServiceNumber(" + number + ")");
        RemoteServicePersistentData remoteServicePersistentData = this.data;
        synchronized (remoteServicePersistentData) {
            this.data.serviceNumber = number;
            this.persistData();
        }
        Trace.trace(TRACE_MASKT, "<- setServiceNumber()");
    }

    public String getServiceNumber() {
        Trace.trace(TRACE_MASKT, "-> getServiceNumber()");
        Trace.trace(TRACE_MASKT, this.data.serviceNumber + " <- getServiceNumber()");
        return this.data.serviceNumber;
    }

    public void restoreOS2Data(Object os2Data, String simName) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> restoreOS2Data(" + os2Data + "," + simName + ")");
        byte[] data = (byte[])os2Data;
        if (simName.equals("XMRC_RSF_PHONE_NUMBERS")) {
            this.setServiceNumber(new NativeString(data, 1, 35).toString());
        } else if (simName.equals("XMRC_RSF_ENABLED")) {
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
            if (rsf != null) {
                rsf.setCallHomeEnabled(data[0] != 0);
            }
        } else if (simName.equals("XMRC_PA_AUTO_AUTH")) {
            this.setAutoServiceCall(data[0] != 0);
        }
        Trace.trace(TRACE_MASKT, "<- restoreOS2Data()");
    }

    static {
        try {
            PersistenceManager pm = PersistenceManager.getPersistenceManager();
            instance = pm.contains(PERSIST_KEY) ? new RemoteServiceData((RemoteServicePersistentData)pm.read(PERSIST_KEY)) : new RemoteServiceData();
        }
        catch (Exception e) {
            instance = new RemoteServiceData();
            new FrameworkLog(logInfo, 6, e).log();
        }
    }

    private static class RemoteServicePersistentData
    implements Persistable,
    PersistentData {
        private static final long serialVersionUID = 1L;
        public boolean enabled = false;
        public boolean autoServiceCall = false;
        public String serviceNumber = null;

        public RemoteServicePersistentData() {
        }

        public RemoteServicePersistentData(PersistentData data) throws PersistenceException {
            RemoteServicePersistentData newData = (RemoteServicePersistentData)data;
            this.enabled = newData.enabled;
            this.autoServiceCall = newData.autoServiceCall;
            this.serviceNumber = newData.serviceNumber;
        }

        public PersistentData getPersistentData() {
            return this;
        }

        public boolean isUpgradeData() {
            return true;
        }

        public String toString() {
            String s = "enabled: " + this.enabled + "\n";
            s = s + "autoServiceCall: " + this.autoServiceCall + "\n";
            s = this.serviceNumber == null ? s + "serviceNumber: null" : s + "serviceNumber: " + this.serviceNumber;
            return s;
        }
    }
}

